/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.dimensions.level.stoneblock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.ftbsbc.dimensions.kubejs.StoneBlockDataKjs;
import dev.ftb.ftbsbc.dimensions.level.stoneblock.StoneBlockBiomeSource;
import dev.ftb.ftbsbc.dimensions.level.stoneblock.StoneblockCarvingContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouterWithOnlyNoises;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNullableByDefault
@MethodsReturnNonnullByDefault
public class StoneblockChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final ResourceLocation STRUCTURE_SET = new ResourceLocation("ftbsbc", "stoneblock_structure_set");
    public static final Codec<StoneblockChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_211073_).forGetter(StoneblockChunkGenerator::getStructureSetRegistry), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(StoneblockChunkGenerator::getNoiseRegistry), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(StoneblockChunkGenerator::getBiomeRegistry), (App)ResourceLocation.f_135803_.fieldOf("prebuilt_structure").forGetter(arg -> arg.prebuiltStructure)).apply((Applicative)instance, instance.stable(StoneblockChunkGenerator::new)));
    public static final NoiseGeneratorSettings SETTINGS = new NoiseGeneratorSettings(NoiseSettings.m_212298_((int)-128, (int)256, (NoiseSamplingSettings)new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), (NoiseSlider)new NoiseSlider(0.9375, 3, 0), (NoiseSlider)new NoiseSlider(2.5, 4, -1), (int)1, (int)2, (TerrainShaper)TerrainProvider.m_198384_()), Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), StoneblockChunkGenerator.none(), SurfaceRules.m_189390_((BlockState)Blocks.f_50069_.m_49966_()), 32, false, false, false, false);
    private final Registry<Biome> biomeRegistry;
    private final Registry<NormalNoise.NoiseParameters> noiseRegistry;
    private Set<Biome> biomesWithCarvers;
    private final HolderSet<StructureSet> structures;
    public final ResourceLocation prebuiltStructure;

    public StoneblockChunkGenerator(@NotNull Registry<StructureSet> structureSetRegistry, @NotNull Registry<NormalNoise.NoiseParameters> noiseParameterRegistry, Registry<Biome> registry, ResourceLocation prebuiltStructure) {
        super(structureSetRegistry, noiseParameterRegistry, (BiomeSource)new StoneBlockBiomeSource(registry), 0L, Holder.m_205709_((Object)SETTINGS));
        this.structures = StoneblockChunkGenerator.getSet(structureSetRegistry);
        this.biomeRegistry = registry;
        this.noiseRegistry = noiseParameterRegistry;
        this.prebuiltStructure = prebuiltStructure;
    }

    private static HolderSet<StructureSet> getSet(Registry<StructureSet> structureSetRegistry) {
        return structureSetRegistry.m_203561_(TagKey.m_203882_((ResourceKey)Registry.f_211073_, (ResourceLocation)STRUCTURE_SET));
    }

    private static NoiseRouterWithOnlyNoises none() {
        return new NoiseRouterWithOnlyNoises(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    public Stream<Holder<StructureSet>> m_207969_() {
        return this.structures.m_203614_();
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public Registry<StructureSet> getStructureSetRegistry() {
        return this.f_207955_;
    }

    public Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public Registry<NormalNoise.NoiseParameters> getNoiseRegistry() {
        return this.noiseRegistry;
    }

    public ChunkGenerator m_6819_(long s) {
        return new StoneblockChunkGenerator((Registry<StructureSet>)this.f_207955_, this.noiseRegistry, this.biomeRegistry, this.prebuiltStructure);
    }

    public Climate.Sampler m_183403_() {
        return new Climate.Sampler(DensityFunctions.m_208264_((double)0.0), DensityFunctions.m_208264_((double)0.0), DensityFunctions.m_208264_((double)0.0), DensityFunctions.m_208264_((double)0.0), DensityFunctions.m_208264_((double)0.0), DensityFunctions.m_208264_((double)0.0), Collections.emptyList());
    }

    public int m_142051_(LevelHeightAccessor arg) {
        return 0;
    }

    public void m_183516_(WorldGenRegion region, long seed1, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
        if (this.biomesWithCarvers == null) {
            this.biomesWithCarvers = new HashSet<Biome>();
            Registry registry = region.m_5962_().m_175515_(Registry.f_122885_);
            for (StoneBlockDataKjs data : StoneBlockDataKjs.BIOMES) {
                if (!data.carvers) continue;
                this.biomesWithCarvers.add((Biome)registry.m_123013_(data.biome));
            }
        }
        BiomeManager biomeManager1 = biomeManager.m_186687_((ix, jx, kx) -> this.f_62137_.m_203407_(ix, jx, kx, this.m_183403_()));
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
        ChunkPos chunkPos = chunkAccess.m_7697_();
        StoneblockCarvingContext carvingContext = new StoneblockCarvingContext(this, region.m_5962_(), chunkAccess.m_183618_());
        CarvingMask carvingMask = ((ProtoChunk)chunkAccess).m_183613_(carving);
        for (int x = -8; x <= 8; ++x) {
            for (int z = -8; z <= 8; ++z) {
                ChunkPos chunkPos1 = new ChunkPos(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z);
                ChunkAccess chunkAccess1 = region.m_6325_(chunkPos1.f_45578_, chunkPos1.f_45579_);
                Holder biome1 = chunkAccess1.m_204344_(() -> this.f_62137_.m_203407_(QuartPos.m_175400_((int)chunkPos1.m_45604_()), 0, QuartPos.m_175400_((int)chunkPos1.m_45605_()), this.m_183403_()));
                if (!this.biomesWithCarvers.contains(biome1.m_203334_())) continue;
                Iterable carvers = ((Biome)biome1.m_203334_()).m_47536_().m_204187_(carving);
                int i = 0;
                for (Holder carver : carvers) {
                    ConfiguredWorldCarver configuredWorldCarver = (ConfiguredWorldCarver)carver.m_203334_();
                    worldgenRandom.m_190068_(seed1 + (long)i, chunkPos1.f_45578_, chunkPos1.f_45579_);
                    if (configuredWorldCarver.m_159273_((Random)worldgenRandom)) {
                        Objects.requireNonNull(biomeManager1);
                        configuredWorldCarver.m_190712_((CarvingContext)carvingContext, chunkAccess, arg_0 -> ((BiomeManager)biomeManager1).m_204214_(arg_0), (Random)worldgenRandom, (Aquifer)NoAquifer.INSTANCE, chunkPos1, carvingMask);
                    }
                    ++i;
                }
            }
        }
    }

    public void m_183621_(WorldGenRegion region, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
    }

    public void m_6929_(WorldGenRegion region) {
    }

    @NotNull
    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Heightmap heightmap1 = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap2 = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        int minY = chunkAccess.m_141937_();
        int height = chunkAccess.m_141928_();
        int cx = chunkAccess.m_7697_().m_45604_();
        int cz = chunkAccess.m_7697_().m_45605_();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int ax = cx + x;
                int az = cz + z;
                StoneBlockDataKjs config = StoneBlockDataKjs.getConfig(ax, az);
                for (int y = minY; y < height; ++y) {
                    BlockState state = config.getState(ax, y, az);
                    chunkAccess.m_6978_((BlockPos)mutableBlockPos.m_122178_(x, y, z), state, false);
                    heightmap1.m_64249_(x, y, z, state);
                    heightmap2.m_64249_(x, y, z, state);
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }

    public int m_6331_() {
        return 256;
    }

    public int m_6337_() {
        return -129;
    }

    public int m_142062_() {
        return -128;
    }

    public int m_142647_(int x, int z, Heightmap.Types heightmap, LevelHeightAccessor level) {
        return 127;
    }

    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor level) {
        BlockState[] blockStates = new BlockState[256];
        StoneBlockDataKjs.getConfig(x, z).fillColumn(x, z, blockStates);
        return new NoiseColumn(level.m_141937_(), blockStates);
    }

    public void m_207076_(List<String> list, BlockPos arg) {
    }

    public static class NoAquifer
    implements Aquifer {
        public static final NoAquifer INSTANCE = new NoAquifer();

        @Nullable
        public BlockState m_207104_(DensityFunction.FunctionContext arg, double d) {
            return Blocks.f_50627_.m_49966_();
        }

        public boolean m_142203_() {
            return false;
        }
    }
}

